/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.math.BigDecimal;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.buttons.AbstractSliderButton;
import journeymap.client.ui.component.buttons.SliderButton;
import journeymap.common.properties.config.FloatField;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_327;

public class FloatSliderButton
extends AbstractSliderButton
implements IConfigFieldHolder<FloatField>,
SliderButton {
    public String prefix = "";
    public boolean dragging = false;
    public float minValue = 0.0f;
    public float maxValue = 0.0f;
    public String suffix = "";
    public boolean drawString = true;
    private float incrementValue = 0.1f;
    private int precision = 2;
    FloatField field;

    public FloatSliderButton(FloatField field, String prefix, String suf) {
        this(field, prefix, suf, field.getMinValue(), field.getMaxValue());
    }

    public FloatSliderButton(FloatField field, String prefix, String suf, float minVal, float maxVal) {
        this(field, prefix, suf, minVal, maxVal, field.getIncrementValue(), field.getPrecision());
    }

    public FloatSliderButton(FloatField field, String prefix, String suf, float minVal, float maxVal, float incrementValue, int precision) {
        super(field, prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.prefix = prefix;
        this.suffix = suf;
        this.field = field;
        this.setValue(field.get().floatValue());
        this.disabledLabelColor = RGB.DARK_GRAY_RGBA;
        this.incrementValue = incrementValue;
        this.precision = precision;
    }

    @Override
    public boolean method_25403(class_11909 event, double mouseDX, double mouseDY) {
        if (this.field_22764 && this.isEnabled() && this.method_25405(event.comp_4798(), event.comp_4799()) && this.dragging) {
            this.setValueFromMouse(event.comp_4798());
            if (this.clickListeners != null) {
                this.checkClickListeners();
            }
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(super.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.mouseOver(event.comp_4798(), event.comp_4799())) {
            this.dragging = true;
            this.setValueFromMouse(event.comp_4798());
            this.checkClickListeners();
            return true;
        }
        return false;
    }

    @Override
    public double getSliderValue() {
        return (this.field.get().floatValue() - this.minValue) / (this.maxValue - this.minValue);
    }

    public void setSliderValue(double sliderValue) {
        float val = (float)sliderValue * (this.maxValue - this.minValue) + this.minValue;
        this.setValue(val);
    }

    @Override
    public void updateLabel() {
        if (this.drawString) {
            this.method_25355((class_2561)Constants.getStringTextComponent(this.prefix + this.field.get() + this.suffix));
        }
    }

    public boolean method_25406(class_11909 event) {
        if (this.dragging) {
            this.dragging = false;
            this.field.save();
            this.checkClickListeners();
        }
        return super.method_25406(event);
    }

    @Override
    public int getFitWidth(class_327 fr) {
        int max = fr.method_1727(this.prefix + this.minValue + this.suffix);
        max = Math.max(max, fr.method_1727(this.prefix + this.maxValue + this.suffix));
        return max + this.WIDTH_PAD;
    }

    public boolean method_25404(class_11908 event) {
        int key = event.comp_4795();
        if (this.isEnabled()) {
            if (key == 263 || key == 45) {
                this.setValue(Math.max(this.minValue, this.getValue() - this.incrementValue));
                if (this.clickListeners != null) {
                    this.checkClickListeners();
                }
                return true;
            }
            if (key == 262 || key == 61) {
                this.setValue(Math.min(this.maxValue, this.getValue() + this.incrementValue));
                if (this.clickListeners != null) {
                    this.checkClickListeners();
                }
                return true;
            }
        }
        return false;
    }

    public float getValue() {
        return this.field.get().floatValue();
    }

    public void setValue(float value) {
        float roundedValue = new BigDecimal(value).setScale(this.precision, 4).floatValue();
        roundedValue = Math.min(roundedValue, this.maxValue);
        roundedValue = Math.max(roundedValue, this.minValue);
        if (this.field.get().floatValue() != roundedValue) {
            this.field.set(Float.valueOf(roundedValue));
            if (!this.dragging) {
                this.field.save();
            }
        }
        this.updateLabel();
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get().floatValue());
    }

    @Override
    public FloatField getConfigField() {
        return this.field;
    }
}

